﻿/********************************************************/
/*						FERTIG.							*/
/*					www.astro-susi.de					*/
/********************************************************/
dynamic class InkEffect {
	private var container:MovieClip;
	private var shape:MovieClip;
	private var mask:MovieClip;
	private var pixel:String;
	// vars: changeable
	public var useMask:Boolean = true;		// masking the shape leads to cleaner edges
	public var rotate:Boolean = false;		// vary rotation of pixels
	public var numSeeds:Number = 50; 		// start with numSeeds seeds
	public var pxSize:Number; 				// size of pixels (default: original size)
	public var pxDist:Number = 1; 			// distance between pixels
	public var speed:Number = 30; 			// speed
	public var rewindSpeed:Number = 60;		// rewind speed
	public var startGrowAlpha:Number = 20; 	// alpha where seeds start growing
	public var minSeeds:Number = 15; 		// min number of current growing pixels ( < numSeeds)
	public var alphaMax:Number = 50; 		// stop fade-in when alphaMax is reached
	private var changeable:Array = new Array("useMask","rotate","numSeeds","pxSize","pxDist","speed","rewindSpeed","startGrowAlpha","minSeeds","alphaMax");
	// vars: not changeable
	private var pa:Array;
	private var pa_bk:Array;
	private var w:Number = 0;
	private var h:Number = 0;
	private var ones:Number = 0;			// anzahl 1er im array
	private var startOnes:Array;			// array mit indizes der 1er in pa
	private var currentGrowing:Number = 0;	// anzahl gerade wachsender pixel
	private var visiblePx:Array;
	private var rewinding:Boolean = false;
	public var hasShape:Boolean = false;
	
	/****************************************/
	/*				CONSTRUCTOR				*/
	/****************************************/
	public function InkEffect( pContainer:MovieClip, pPixel:String, initObj:Object ) {
		container = pContainer;
		container.classRef = this;
		pixel = pPixel;
		if (initObj != null) {
			for (var i in initObj) {
				if (inArray(i,changeable)) {
					this[i] = initObj[i];
				}
			}
			if (minSeeds > numSeeds) {
					minSeeds = numSeeds;
			}
		}
	}
	/****************************************/
	/*				LISTENER				*/
	/****************************************/
	public function onEffectFinished():Void{}
	public function onRewindFinished():Void{}
	/****************************************/
	/*				METHODS					*/
	/****************************************/
	// show effect
	public function startEffect():Void {
		// clean up
		currentGrowing = 0;
		shape._alpha = 0;
		pa = copyArr( pa_bk );
		// sow
		var ns:Number = numSeeds;
		while (ns--) {
			seed();
		}
		delete container.onEnterFrame;
		container.onEnterFrame = function() {
			if (this.classRef.ones > 1) {
				var t:Number = (this.classRef.ones < this.classRef.minSeeds) ? this.classRef.ones : this.classRef.minSeeds;
				if (this.classRef.currentGrowing < t) {
					this.classRef.seed();
				}
			} else {
				delete this.onEnterFrame;
				this.classRef.onEffectFinished();
				for ( var i:Number = 0; i < this.classRef.startOnes.length; i++ ) {
					delete this["p"+this.classRef.startOnes[i]].onEnterFrame;
				}
			}
		}
	}
	// stop/pause effect
	public function stopEffect():Void {
		for ( var i:Number = 0; i < startOnes.length; i++ ) {
			container["p"+startOnes[i]].oef = container["p"+startOnes[i]].onEnterFrame;
			delete container["p"+startOnes[i]].onEnterFrame;
		}
		container.oef = container.onEnterFrame;
		delete container.onEnterFrame;
	}
	// continue effect
	public function continueEffect():Void {
		for ( var i:Number = 0; i < startOnes.length; i++ ) {
			container["p"+startOnes[i]].onEnterFrame = container["p"+startOnes[i]].oef;
		}
		container.onEnterFrame = container.oef;
	}
	// rewind effect
	public function rewindEffect():Void {
		pa = copyArr( pa_bk );
		delete container.onEnterFrame;
		container.onEnterFrame = function() {
			if (this.classRef.visiblePx.length > 0) {
				for (var i:Number = 0; i<this.classRef.rewindSpeed && this.classRef.visiblePx.length > 0; i++) {
					(this.classRef.visiblePx.pop()).removeMovieClip(); // or use shift() instead
					this.classRef.ones++;
				}
			} else {
				delete this.onEnterFrame;
				this.classRef.onRewindFinished();
			}
		}
	}
	// add shape to container and set mask
	public function addShape( id:String, pMask:MovieClip ):Void {
		destroy();
		hasShape = true;
		shape = container.attachMovie( id, "s", 0 );
		if (useMask) {
			if (pMask == null) {
				// no mask -> duplicate shape and use as mask
				mask = container.attachMovie( id, "m", 1 );
			}
			container.setMask( mask );
		}
		pa = createPixelArray();
		pa_bk = copyArr( pa );
	}
	// creates Array pa for shape; sets: w, h, ones, startOnes, visiblePx
	private function createPixelArray():Array {
		var d:Number = 0;
		var p:Array = new Array();
		w = Math.round(container._width/pxDist);
		h = Math.round(container._height/pxDist);
		ones = 0;
		startOnes = new Array();
		visiblePx = new Array();
		pa_bk = new Array();
		var zeroCoordinates:Object = {x:0, y:0};
  		container.localToGlobal(zeroCoordinates);
		for (var j = 0; j<h; j++) {
			for (var i = 0; i<w; i++) {
				if (container.s.hitTest(i*pxDist+zeroCoordinates.x, j*pxDist+zeroCoordinates.y, true)) {
					p[d] = 1;
					ones++;
					startOnes.push(d);
				} else {
					p[d] = 0;
				}
				d++;
			}
		}
		shape.removeMovieClip();
		return p;
	}
	// sow seeds
	private function seed():Void {
		var i:Number = startOnes[Math.floor(Math.random()*startOnes.length)];
		if (pa[i]) {
			pa[i] = 0;
			ones--;
			currentGrowing++;
			var x:MovieClip = container.attachMovie(pixel, "p"+i, (i+10), {_alpha:0, mcSpeed:Math.random()*speed+1, i:i, classRef:this});
			x.onEnterFrame = function () {
				this._alpha += this.mcSpeed;
				if (this._alpha>this.classRef.startGrowAlpha && !this.growing) {
					this.classRef.grow(this.i);
					this.growing = true;
				}
				if (this._alpha>this.classRef.alphaMax) {
					delete this.onEnterFrame;
					this.classRef.currentGrowing--;
				}
			};
			pos(x, i);
			visiblePx.push(x);
		} else {
			seed();
		}
	}
	// grow
	function grow(i) {
		// growArray
		var growArray:Array = new Array();
		if ((Math.floor((i-1)/w) == Math.floor(i/w)) && pa[i-1]) {
			growArray.push(i-1);
			pa[i-1] = 0;
			ones--;
		}
		if ((Math.floor((i+1)/w) == Math.floor(i/w)) && pa[i+1]) {
			growArray.push(i+1);
			pa[i+1] = 0;
			ones--;
		}
		if (i+w<pa.length && pa[i+w]) {
			growArray.push(i+w);
			pa[i+w] = 0;
			ones--;
		}
		if (i-w>0 && pa[i-w]) {
			growArray.push(i-w);
			pa[i-w] = 0;
			ones--;
		}
		// growing
		for (var k = 0; k<growArray.length; k++) {
			currentGrowing++;
			var x:MovieClip = container.attachMovie(pixel, "p"+growArray[k], (growArray[k]+10), {_alpha:0, mcSpeed:Math.random()*speed+1, i:growArray[k], classRef:this});
			x.onEnterFrame = function () {
				this._alpha += this.mcSpeed;
				if (this._alpha>this.classRef.startGrowAlpha && !this.growing) {
					this.classRef.grow(this.i);
					this.growing = true;
				}
				if (this._alpha>this.classRef.alphaMax) {
					delete this.onEnterFrame;
					this.classRef.currentGrowing--;
				}
			};
			pos(x, growArray[k]);
			visiblePx.push(x);
		}
	}
	// position pixel
	private function pos(p:MovieClip, i:Number):Void {
		p._x = (i%w)*pxDist;
		p._y = Math.floor(i/w)*pxDist;
		if (pxSize != undefined) {
			p._width = pxSize;
			p._height = pxSize;
		}
		if (rotate) {
			p._rotation = Math.random()*90;
		}
	}
	/****************************************/
	/*				HELPERS					*/
	/****************************************/
	public function destroy() {
		mask.removeMovieClip();
		shape.removeMovieClip();
		for ( var i:Number = 0; i < startOnes.length; i++ ) {
			delete container["p"+startOnes[i]].onEnterFrame;
			container["p"+startOnes[i]].removeMovieClip();
		}
		delete container.onEnterFrame;
	}
	public function getValues():Object {
		var a:Object = new Object();
		for (var i in changeable) {
			a[changeable[i]] = this[changeable[i]];
		}
		return a;
	}
	private function inArray( obj:Object, arr:Array ):Boolean {
		var s:Number = arr.length;
		for (var i:Number = 0; i<s; i++) {
			if (arr[i] == obj) {
				return true;
			}
		}
		return false;
	}
	private function copyArr( arr:Array ):Array {
		var a:Array = new Array();
		for (var i=0;i<arr.length;i++) {
			a[i] = arr[i];
		}
		return a;
	}
}
